 ; Ŀ
 ;   Refa - update a set of blocks from a Cdf file.                        
 ;   Copyright 2006 by Rocket Software Ltd.                                
 ;   Read the file Reference.csv into any blocks named Ref*.               
 ;   The line in the csv file to use must begin with the value in the      
 ;   first attribute in the block.  This can be invisible if desired.      
 ;   If the csv line is too long for the number of attributes then the     
 ;   excess will be deleted.  If it is too short then excess attributes    
 ;   will be emptied.                                                      
 ;   If the file Reference.csv isn't in the current directory then Refa    
 ;   searches up one step at a time to the root.                           
 ;                                                                         
 ;                                                                         
 ; 

 ; Ŀ
 ;   Blynt - place new values into a block starting at a given attribute.  
 ;   Arguments: Enam, the attribute name at which to start.                
 ;              Vlasta, the list of new values.                            
 ;   Caution: doesn't check to see if there are attributes available.      
 ; 
 (DEFUN BLYNT (enam vlasta / esav gnuval entt)
  (setq esav enam)
  (while (/= (cdr (assoc 0 (setq entt (entget enam)))) "SEQEND")
         (if (setq gnuval (car vlasta))
             (setq vlasta (cdr vlasta))
             (setq gnuval ""))
         (entmod (subst (cons 1 gnuval) (assoc 1 entt) entt))
         (setq enam (entnext enam)))
  (entupd esav)
 (princ))
 ; Ŀ
 ;   Blynt end.                                                            
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug - end.                                                           
 ; 

 ; Ŀ
 ;   Climb - find a file by climbing the directory tree.                   
 ;   Arguments: Fnam, a file name without path.                            
 ;              Path, if true and the file isn't found in the local tree,  
 ;              do a findfile search for it, i.e. the entire acad path.    
 ;   Calls Dstep.                                                          
 ;   Returns a filename with path string or nil.                           
 ; 
 (DEFUN CLIMB (fnam path / prefa fila)
 ; Ŀ
 ;   Find out where we are, windows being unclear on the concept.          
 ; 
  (setq prefa (getvar "dwgprefix"))
 ; Ŀ
 ;   Step up until find the file or run out of path.                       
 ; 
  (while (and (/= prefa "")
              (not (setq fila (findfile (strcat prefa fnam)))))
         (setq prefa (dstep prefa)))
 ; Ŀ
 ;   If the file wasn't in the current tree, search the whole acad path.   
 ; 
  (if (and (null fila) path)
      (setq fila (findfile fnam)))
 fila)
 ; Ŀ
 ;   Climb end.                                                            
 ; 

 ; Ŀ
 ;   Dstep - remove the last level from a path.                            
 ;   Arguments: Stra, a path string.                                       
 ;   Returns a truncated path or "".                                       
 ; 
 (DEFUN DSTEP (stra / pos)
 ; Ŀ
 ;   The last character will probably be a backslash, therefore remove     
 ;   it so that it doesn't stop the loop.                                  
 ; 
  (setq pos (strlen stra))
  (if (and (/= pos 0)
           (member (substr stra pos 1) '("/" "\\")))
      (setq stra (substr stra 1 (1- pos))))
 ; Ŀ
 ;   Remove the next step.                                                 
 ; 
  (setq pos (strlen stra))
  (while (and (/= pos 0)
              (not (member (substr stra pos 1) '("/" "\\"))))
         (setq pos (1- pos)))
  (setq stra (substr stra 1 pos))
 stra)
 ; Ŀ
 ;   Dstep end.                                                            
 ; 

 ; Ŀ
 ;   Nooke - remove commas from strings which excel has encapsulated in    
 ;   double quotes so that Splat doesn't make one string into several.     
 ;   Takes one argument, the raw data string.                              
 ;   Calls Chug.                                                           
 ;   Returns a more rational string.                                       
 ; 
 (DEFUN NOOKE (linn)
 ; Ŀ
 ;   Fields containing 38" are exported by Excel as "38""", so call Chug   
 ;   to change "" to |+, then " to nothing, then |+ back to ".             
 ; 
  (setq linn (car (chug "\"\"" "|+" linn)))
  (setq linn (car (chug "\"" "" linn)))
  (setq linn (car (chug  "|+" "\"" linn)))
 linn)
 ; Ŀ
 ;   Nooke end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string at a given character, make    
 ;   into a list of substrings.                                            
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (and (/= linn "")
                     (= (substr linn (setq len (strlen linn))) " "))
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= name1 "")
                     (= (substr name1 (setq len (strlen name1))) " "))
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Refa.                                                                 
 ; 
 (DEFUN C:REFA (/ *error* ss filnam fn linn llist malist num enam valone suba)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk)
  (if (/= shk "") (write-line shk))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   If there are any reference blocks to update, find the data file,      
 ;   read it into a list of lists of strings.                              
 ; 
  (if (and (setq ss (ssget "x" (list (cons 2 "ref*"))))
 ; Ŀ
 ;   Get a filename.  Climb the directory tree if necessary.               
 ; 
           (setq filnam (climb "reference.csv" nil)))
      (progn
           (prompt (strcat "\nRefa.lsp is using the data file: " filnam "."))
 ; Ŀ
 ;   Read the file into a list of lists of strings.                        
 ; 
           (setq fn (open filnam "r"))
           (while (setq linn (read-line fn))
                  (setq linn (nooke linn))
                  (if (/= "" (setq llist (splat "," linn)))
                      (setq malist (cons llist malist))))
           (close fn)
           (setq malist (reverse malist))
 ; Ŀ
 ;   Find the sublist for each block.                                      
 ; 
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq valone (cdr (assoc 1
                                       (entget (setq enam (entnext enam))))))
 ; Ŀ
 ;   If there is a sublist then replace the attributes in the block.       
 ; 
                  (if (setq suba (assoc valone malist))
                      (blynt enam suba)))))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (command "undo" "end")
 (princ))